<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'des', 'phone', 'city_id', 'nationality', 'whats_number', 'years_skills', 'degree', 'type', 'password', 'is_busy');
    protected $hidden = array('password');

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function categories()
    {
        return $this->belongsToMany('App\Models\Category');
    }

    public function works()
    {
        return $this->hasMany('App\Models\Work');
    }

    public function rates()
    {
        return $this->hasMany('App\Models\Rate');
    }

}